/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.change.changes;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.changes.IChange;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.utils.BitInventoryUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.apache.commons.lang3.Validate;

public class BitChange
implements IChange {
    private class_2487 lazyLoadingTag;
    private class_2338 blockPos;
    private IMultiStateSnapshot before;
    private IMultiStateSnapshot after;

    public BitChange(class_2338 blockPos, IMultiStateSnapshot before, IMultiStateSnapshot after) {
        this.blockPos = blockPos;
        this.before = before;
        this.after = after;
    }

    public BitChange(class_2520 tag) {
        Validate.isInstanceOf(class_2487.class, (Object)tag);
        this.lazyLoadingTag = (class_2487)tag;
    }

    private void load() {
        if (this.lazyLoadingTag == null) {
            return;
        }
        this.deserializeNBT(this.lazyLoadingTag);
        this.lazyLoadingTag = null;
    }

    @Override
    public boolean canUndo(class_1657 player) {
        this.load();
        class_2586 tileEntity = player.field_6002.method_8321(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            class_2680 state = player.field_6002.method_8320(this.blockPos);
            Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(state, Optional.ofNullable(player.field_6002.method_8321(this.blockPos)));
            BlockInformation currentState = new BlockInformation(state, additionalStateInfo);
            return this.after.getStatics().getStateCounts().size() == 1 && this.after.getStatics().getStateCounts().getOrDefault(currentState, 0) == 4096;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        return this.after.createNewShapeIdentifier().equals(multiStateBlockEntity.createNewShapeIdentifier()) && this.hasRequiredUndoBits(player);
    }

    @Override
    public boolean canRedo(class_1657 player) {
        this.load();
        class_2586 tileEntity = player.field_6002.method_8321(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            class_2680 state = player.field_6002.method_8320(this.blockPos);
            Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(state, Optional.ofNullable(player.field_6002.method_8321(this.blockPos)));
            BlockInformation currentState = new BlockInformation(state, additionalStateInfo);
            return this.before.getStatics().getStateCounts().size() == 1 && this.before.getStatics().getStateCounts().getOrDefault(currentState, 0) == 4096;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        return this.before.createNewShapeIdentifier().equals(multiStateBlockEntity.createNewShapeIdentifier()) && this.hasRequiredRedoBits(player);
    }

    @Override
    public void undo(class_1657 player) throws IllegalChangeAttempt {
        this.load();
        if (!this.canUndo(player)) {
            throw new IllegalChangeAttempt();
        }
        class_2586 tileEntity = player.field_6002.method_8321(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            class_2680 currentState = player.field_6002.method_8320(this.blockPos);
            Optional<class_2248> convertedState = IConversionManager.getInstance().getChiseledVariantOf(currentState);
            if (convertedState.isEmpty()) {
                throw new IllegalChangeAttempt();
            }
            player.field_6002.method_8652(this.blockPos, convertedState.get().method_9564(), 3);
            tileEntity = player.field_6002.method_8321(this.blockPos);
            if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                throw new IllegalChangeAttempt();
            }
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        Map<BlockInformation, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockInformation, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, afterStates.getOrDefault(state, 0) - count));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, count);
            }
        });
        try (IBatchMutation batch = multiStateBlockEntity.batch();){
            multiStateBlockEntity.initializeWith(BlockInformation.AIR);
            this.before.stream().forEach(iStateEntryInfo -> {
                try {
                    multiStateBlockEntity.setInAreaTarget(iStateEntryInfo.getBlockInformation(), iStateEntryInfo.getStartPoint());
                }
                catch (SpaceOccupiedException spaceOccupiedException) {
                    // empty catch block
                }
            });
        }
        if (!player.method_7337()) {
            IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
            difference.forEach((state, diff) -> {
                if (state.isAir()) {
                    return;
                }
                if (diff < 0) {
                    bitInventory.extract((BlockInformation)state, -diff.intValue());
                } else {
                    BitInventoryUtils.insertIntoOrSpawn(player, state, diff);
                }
            });
        }
    }

    @Override
    public void redo(class_1657 player) throws IllegalChangeAttempt {
        this.load();
        if (!this.canRedo(player)) {
            throw new IllegalChangeAttempt();
        }
        class_2586 tileEntity = player.field_6002.method_8321(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            Optional<class_2248> convertedState;
            class_2680 currentState;
            class_2680 initializationState = currentState = player.field_6002.method_8320(this.blockPos);
            if (currentState.method_26215()) {
                currentState = class_2246.field_10340.method_9564();
            }
            if ((convertedState = IConversionManager.getInstance().getChiseledVariantOf(currentState)).isEmpty()) {
                throw new IllegalChangeAttempt();
            }
            player.field_6002.method_8652(this.blockPos, convertedState.get().method_9564(), 3);
            tileEntity = player.field_6002.method_8321(this.blockPos);
            if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                throw new IllegalChangeAttempt();
            }
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        Map<BlockInformation, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockInformation, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, count - afterStates.getOrDefault(state, 0)));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, -count.intValue());
            }
        });
        try (IBatchMutation batch = multiStateBlockEntity.batch();){
            multiStateBlockEntity.initializeWith(BlockInformation.AIR);
            this.after.stream().forEach(s -> {
                try {
                    multiStateBlockEntity.setInAreaTarget(s.getBlockInformation(), s.getStartPoint());
                }
                catch (SpaceOccupiedException spaceOccupiedException) {
                    // empty catch block
                }
            });
        }
        if (!player.method_7337()) {
            IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
            difference.forEach((state, diff) -> {
                if (diff < 0) {
                    bitInventory.extract((BlockInformation)state, -diff.intValue());
                } else {
                    BitInventoryUtils.insertIntoOrSpawn(player, state, diff);
                }
            });
        }
    }

    private boolean hasRequiredUndoBits(class_1657 player) {
        if (player.method_7337()) {
            return true;
        }
        Map<BlockInformation, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockInformation, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, afterStates.getOrDefault(state, 0) - count));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, count);
            }
        });
        IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
        return difference.entrySet().stream().filter(e -> (Integer)e.getValue() < 0).allMatch(e -> bitInventory.canExtract((BlockInformation)e.getKey(), -((Integer)e.getValue()).intValue()));
    }

    private boolean hasRequiredRedoBits(class_1657 player) {
        if (player.method_7337()) {
            return true;
        }
        Map<BlockInformation, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockInformation, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, count - afterStates.getOrDefault(state, 0)));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, -count.intValue());
            }
        });
        IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
        return difference.entrySet().stream().filter(e -> (Integer)e.getValue() < 0).allMatch(e -> bitInventory.canExtract((BlockInformation)e.getKey(), -((Integer)e.getValue()).intValue()));
    }

    @Override
    public class_2487 serializeNBT() {
        if (this.lazyLoadingTag != null) {
            return this.lazyLoadingTag.method_10553();
        }
        class_2487 tag = new class_2487();
        tag.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)this.blockPos));
        tag.method_10566("before", (class_2520)this.before.toItemStack().toBlockStack().method_7953(new class_2487()));
        tag.method_10566("after", (class_2520)this.after.toItemStack().toBlockStack().method_7953(new class_2487()));
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.blockPos = class_2512.method_10691((class_2487)nbt.method_10562("pos"));
        this.before = BitChange.deserializeSnapshot(nbt.method_10562("before"));
        this.after = BitChange.deserializeSnapshot(nbt.method_10562("after"));
    }

    private static IMultiStateSnapshot deserializeSnapshot(class_2487 nbt) {
        class_1799 stack = class_1799.method_7915((class_2487)nbt);
        if (stack.method_7960()) {
            return EmptySnapshot.INSTANCE;
        }
        if (!(stack.method_7909() instanceof IMultiStateItem)) {
            return EmptySnapshot.INSTANCE;
        }
        return ((IMultiStateItem)stack.method_7909()).createItemStack(stack).createSnapshot();
    }
}

